# Copyright (C) 2013-2023 Echelon Corporation.  All Rights Reserved.
# Use of this code is subject to your compliance with the terms of the
# Echelon IzoT(tm) Software Developer's Kit License Agreement which is
# available at www.echelon.com/license/izot_sdk/.

# IzoT resources contained in this file are generated by an automated
# database to source code conversion process.  Grammar and punctuation within
# the embedded documentation may not be correct, as this data is gathered and
# combined from several sources.
# Names of resources and fields or members defined within a resource are
# derived from the same sources.  Names, capitalization and aspects of source
# code formatting may fail to comply with PEP-8 and PEP-257 recommendations
# due to the automated generation of these IzoT definitions.
# Generated at 11-May-2023 17:11.

"""BTLtest userdefined profile, originally defined in resource file set
apollodev 90:00:01:06:00:00:00:00-4."""


import izot.resources.base
from P9000010600000000_4.userdefined import userdefined
import izot.resources.datapoints.count
import izot.resources.datapoints.count_inc_f
import izot.resources.datapoints.occupancy
import izot.resources.datapoints.str_asc
import P9000010600000000_4.datapoints.bacnetInt
import P9000010600000000_4.datapoints.bacnetPosInt
import P9000010600000000_4.datapoints.largeAv


class BTLtest(izot.resources.base.Profile):
    """BTLtest userdefined profile.  """

    def __init__(self):
        super().__init__(
            key=20025,
            scope=4
        )
        self.datapoints['nviBO'] = izot.resources.base.Profile.DatapointMember(
            doc="""Absolute count.  BO example.""",
            name='nviBO',
            profile=self,
            number=1,
            datatype=izot.resources.datapoints.count.count,
            mandatory=True,
            minimum=b'\x00\x00',
            maximum=b'\x00\x01',
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nvoBI'] = izot.resources.base.Profile.DatapointMember(
            doc="""Absolute count.  BI example.""",
            name='nvoBI',
            profile=self,
            number=2,
            datatype=izot.resources.datapoints.count.count,
            mandatory=True,
            minimum=b'\x00\x00',
            maximum=b'\x00\x01',
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nviBV'] = izot.resources.base.Profile.DatapointMember(
            doc="""Absolute count.  BV example.""",
            name='nviBV',
            profile=self,
            number=3,
            datatype=izot.resources.datapoints.count.count,
            mandatory=True,
            minimum=b'\x00\x00',
            maximum=b'\x00\x01',
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nviAO'] = izot.resources.base.Profile.DatapointMember(
            doc="""Increment count.  Example AO.""",
            name='nviAO',
            profile=self,
            number=4,
            datatype=izot.resources.datapoints.count_inc_f.count_inc_f,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nvoAI'] = izot.resources.base.Profile.DatapointMember(
            doc="""Increment count.  Example AI.""",
            name='nvoAI',
            profile=self,
            number=5,
            datatype=izot.resources.datapoints.count_inc_f.count_inc_f,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nviAV'] = izot.resources.base.Profile.DatapointMember(
            doc="""Increment count.  Example AV.""",
            name='nviAV',
            profile=self,
            number=6,
            datatype=izot.resources.datapoints.count_inc_f.count_inc_f,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nviMSO'] = izot.resources.base.Profile.DatapointMember(
            doc="""Occupancy Example MS0.""",
            name='nviMSO',
            profile=self,
            number=7,
            datatype=izot.resources.datapoints.occupancy.occupancy,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nviMSV'] = izot.resources.base.Profile.DatapointMember(
            doc="""Occupancy Example MS0.""",
            name='nviMSV',
            profile=self,
            number=8,
            datatype=izot.resources.datapoints.occupancy.occupancy,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nvoMSI'] = izot.resources.base.Profile.DatapointMember(
            doc="""Occupancy Example MS0.""",
            name='nvoMSI',
            profile=self,
            number=9,
            datatype=izot.resources.datapoints.occupancy.occupancy,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nviString'] = izot.resources.base.Profile.DatapointMember(
            doc="""Character string (30 characters max) Example Char
            string.""",
            name='nviString',
            profile=self,
            number=10,
            datatype=izot.resources.datapoints.str_asc.str_asc,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nviInteger'] = izot.resources.base.Profile.DatapointMember(
            doc=""" """,
            name='nviInteger',
            profile=self,
            number=11,
            datatype=P9000010600000000_4.datapoints.bacnetInt.bacnetInt,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nviPosInteger'] = izot.resources.base.Profile.DatapointMember(
            doc=""" """,
            name='nviPosInteger',
            profile=self,
            number=12,
            datatype=P9000010600000000_4.datapoints.bacnetPosInt.bacnetPosInt,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nviLargeAV'] = izot.resources.base.Profile.DatapointMember(
            doc=""" """,
            name='nviLargeAV',
            profile=self,
            number=13,
            datatype=P9000010600000000_4.datapoints.largeAv.largeAv,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self._original_name = 'UFPTBTLtest'
        self._definition = userdefined.add(self)
        self.finalize()


if __name__ == '__main__':
    # unit test code.
    item = BTLtest()
    pass
